/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ipv6;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import java.io.Serializable;

public class IPv6Address
implements Serializable {
    private OctetString ipaddrOctet;
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public IPv6Address(IPv6Address iPv6Address) {
        this(iPv6Address.getBytes());
    }

    public IPv6Address(byte[] byArray) {
        this(byArray, 0);
    }

    public IPv6Address(byte[] byArray, int n) {
        this.ipaddrOctet = new OctetString(byArray, n, byArray.length);
    }

    public IPv6Address(String string) {
        this.ipaddrOctet = this.fromString(string);
    }

    public String toString() {
        String string = this.ipaddrOctet.toString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        if (string.length() != 32) {
            return string;
        }
        if (string.equals("00000000000000000000000000000000")) {
            return "::";
        }
        if (string.equals("00000000000000000000000000000001")) {
            return "::1";
        }
        int n2 = 0;
        while (n2 < 32) {
            String string2 = string.substring(n2, n2 + 4);
            string2.toUpperCase();
            if (string2.equals("0000")) {
                ++n;
                if (!bl2) {
                    stringBuffer.append("0");
                }
                if (n == 6 && n2 == 20) {
                    bl = true;
                }
            } else {
                if (n == 1) {
                    stringBuffer.append("0:");
                }
                if (n > 1) {
                    stringBuffer.append(":");
                    bl2 = false;
                    if (bl3) {
                        stringBuffer.append(":");
                    }
                }
                string2 = this.zeroStrip(string2);
                stringBuffer.append(string2);
                if (n == 5 && n2 == 20 && string2.equals("FFFF")) {
                    bl = true;
                }
                n = 0;
                bl3 = false;
            }
            if (n2 == 28) {
                if (n == 1) {
                    stringBuffer.append("0");
                }
                if (n > 1) {
                    stringBuffer.append(":");
                }
                if (n == 8) {
                    stringBuffer.append(":");
                }
            } else if (n == 0) {
                stringBuffer.append(":");
            }
            if (bl) {
                if (n > 4) {
                    stringBuffer.append(":");
                }
                if (n == 6) {
                    stringBuffer.append(":");
                }
                IPAddress iPAddress = new IPAddress(this.ipaddrOctet.value, 12);
                stringBuffer.append(iPAddress.getIpAddress());
                break;
            }
            n2 += 4;
        }
        return stringBuffer.toString().toUpperCase();
    }

    public String getIpAddress() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.ipaddrOctet.value;
    }

    public boolean equals(IPv6Address iPv6Address) {
        byte[] byArray = this.ipaddrOctet.value;
        byte[] byArray2 = iPv6Address.getBytes();
        boolean bl = true;
        int n = 0;
        while (n < 16) {
            if (byArray[n] != byArray2[n]) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    public OctetString fromString(String string) {
        if (string.length() == 0) {
            return new OctetString("00");
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        String string2 = null;
        try {
            if (string != null) {
                StringBuffer stringBuffer2 = new StringBuffer(5);
                int n = 0;
                String string3 = new String("0000");
                boolean bl4 = true;
                boolean bl5 = false;
                StringBuffer stringBuffer3 = new StringBuffer(32);
                StringBuffer stringBuffer4 = new StringBuffer(32);
                StringBuffer stringBuffer5 = new StringBuffer(32);
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                byte[] byArray = new byte[4];
                int n6 = 4;
                string = string.toUpperCase();
                int n7 = 0;
                while (n7 < string.length()) {
                    String string4 = string.substring(n7, n7 + 1);
                    if (string4.equals(":")) {
                        bl = false;
                        n6 = 4;
                        ++n3;
                        if (++n2 > 7) {
                            bl3 = false;
                            break;
                        }
                        if (n3 > 2) {
                            bl3 = false;
                            break;
                        }
                        if (bl2) {
                            bl3 = false;
                            break;
                        }
                        if (bl4) {
                            stringBuffer3.append(String.valueOf(string3.substring(0, 4 - n)) + stringBuffer2.toString());
                        } else {
                            stringBuffer4.append(String.valueOf(string3.substring(0, 4 - n)) + stringBuffer2.toString());
                        }
                        stringBuffer2 = new StringBuffer(5);
                        n = 0;
                        if (n3 == 2) {
                            if (bl5) {
                                bl3 = false;
                                break;
                            }
                            bl4 = false;
                            bl5 = true;
                        }
                    } else if (string4.equals(".")) {
                        bl2 = true;
                        n6 = 3;
                        ++n4;
                        ++n5;
                        if (n > n6) {
                            bl3 = false;
                            break;
                        }
                        if (n4 > 3) {
                            bl3 = false;
                            break;
                        }
                        if (n5 > 1) {
                            bl3 = false;
                            break;
                        }
                        int n8 = Integer.parseInt(stringBuffer2.toString());
                        if (n8 > 255) {
                            bl3 = false;
                            break;
                        }
                        byArray[n4 - 1] = (byte)n8;
                        stringBuffer2 = new StringBuffer(5);
                        n = 0;
                    } else {
                        n3 = 0;
                        n5 = 0;
                        stringBuffer2.append(string4);
                        if (++n > n6) {
                            bl3 = false;
                            break;
                        }
                        if (bl2 && !Character.isDigit(string4.charAt(0))) {
                            bl3 = false;
                            break;
                        }
                        if (!this.isHex(string4.charAt(0))) {
                            bl3 = false;
                            break;
                        }
                    }
                    ++n7;
                }
                if (bl3) {
                    if (bl2) {
                        int n9;
                        ++n5;
                        ++n2;
                        if (++n4 != 4) {
                            bl3 = false;
                        }
                        if (n5 > 1) {
                            bl3 = false;
                        }
                        if ((n9 = Integer.parseInt(stringBuffer2.toString())) > 255) {
                            bl3 = false;
                        } else {
                            byArray[3] = (byte)n9;
                        }
                        if (bl3) {
                            stringBuffer4.append(this.myHex(byArray));
                        }
                    } else if (bl4) {
                        stringBuffer3.append(String.valueOf(string3.substring(0, 4 - n)) + stringBuffer2.toString());
                    } else {
                        stringBuffer4.append(String.valueOf(string3.substring(0, 4 - n)) + stringBuffer2.toString());
                    }
                    stringBuffer.append(stringBuffer3.toString());
                    if (bl5) {
                        int n10 = 0;
                        while (n10 < 7 - n2) {
                            stringBuffer5.append(string3);
                            ++n10;
                        }
                        stringBuffer.append(stringBuffer5.toString());
                    }
                    stringBuffer.append(stringBuffer4.toString());
                }
                if (bl) {
                    if (stringBuffer.length() != 8) {
                        bl3 = false;
                    }
                } else if (stringBuffer.length() != 32) {
                    bl3 = false;
                }
            } else {
                bl3 = false;
            }
        }
        catch (Exception exception) {
            bl3 = false;
        }
        string2 = bl3 ? stringBuffer.toString() : "00";
        return new OctetString(string2);
    }

    private String zeroStrip(String string) {
        String string2 = string;
        if (string2 != null && string2.trim() != null) {
            int n = 0;
            while (n < string.length()) {
                if (string2.startsWith("0")) {
                    string2 = string2.substring(1);
                }
                ++n;
            }
        }
        return string2;
    }

    public String myHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] >> 4 & 0xF;
            int n3 = byArray[n] & 0xF;
            stringBuffer.append(hexchars[n2]);
            stringBuffer.append(hexchars[n3]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isHex(char c) {
        int n = 0;
        while (n < 16) {
            if (c == hexchars[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

